/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class PluginUnInstallDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getI18n();
    private Manifest manifest = null;
    private Boolean delete = Boolean.FALSE;
    private Boolean deleteUserData = Boolean.FALSE;

    public PluginUnInstallDialog(Manifest mf) {
        super(1);
        this.setTitle(i18n.tr("Plugin {0} deinstallieren", mf.getName()));
        this.setSideImage(SWTUtil.getImage("dialog-warning-large.png"));
        this.manifest = mf;
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        SimpleContainer container = new SimpleContainer(parent);
        container.addText(i18n.tr("Sind Sie sicher, dass Sie das Plugin jetzt deinstallieren wollen?"), true);
        final LabelInput warning = new LabelInput("\n\n");
        warning.setName("");
        warning.setColor(Color.ERROR);
        final CheckboxInput check = new CheckboxInput(false);
        check.setName(i18n.tr("Benutzerdaten des Plugins ebenfalls l\u00f6schen"));
        check.addListener(new Listener(){

            public void handleEvent(Event event) {
                if (((Boolean)check.getValue()).booleanValue()) {
                    warning.setValue(i18n.tr("Die Benutzerdaten gehen unwiederbringlich verloren!\nErstellen Sie im Zweifel ein Backup des Benutzer-Ordners."));
                } else {
                    warning.setValue("\n\n");
                }
            }
        });
        if (this.manifest.isInstalled()) {
            container.addInput(check);
        }
        container.addInput(warning);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("Plugin jetzt deinstallieren"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                try {
                    boolean b = (Boolean)check.getValue();
                    if (b && !Application.getCallback().askUser(i18n.tr("Sind Sie wirklich sicher, dass Sie auch die Benutzerdaten\ndes Plugins l\u00f6schen m\u00f6chten?"))) {
                        check.setValue(false);
                        warning.setValue("\n\n");
                        return;
                    }
                    PluginUnInstallDialog.this.delete = true;
                    PluginUnInstallDialog.this.deleteUserData = b;
                    PluginUnInstallDialog.this.close();
                }
                catch (ApplicationException ae) {
                    throw ae;
                }
                catch (Exception e) {
                    Logger.error((String)"unable to perform action", (Throwable)e);
                    throw new ApplicationException(i18n.tr(e.getMessage()));
                }
            }
        }, null, false, "user-trash-full.png");
        buttons.addButton(i18n.tr("Abbrechen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException("operation cancelled");
            }
        }, null, true, "process-stop.png");
        container.addButtonArea(buttons);
    }

    protected Object getData() throws Exception {
        return this.delete;
    }

    public boolean getDeleteUserData() {
        return this.deleteUserData;
    }
}

